% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_field_class}
\alias{check_field_class}
\alias{assert_field_class}
\title{Check the classes of fields in a GTFS object element}
\usage{
check_field_class(x, file, fields, classes)

assert_field_class(x, file, fields, classes)
}
\arguments{
\item{x}{A GTFS object.}

\item{file}{A string. The element, that represents a GTFS text file, whose
fields' classes should be checked.}

\item{fields}{A character vector. The fields to have their classes checked.}

\item{classes}{A character vector, with the same length of \code{fields}. The
classes that each field must inherit from.}
}
\value{
\code{check_field_class} returns \code{TRUE} if the check is successful, and
\code{FALSE} otherwise. \cr
\code{assert_field_class} returns \code{x} invisibly if the check is
successful, and throws an error otherwise.
}
\description{
Checks the classes of fields, represented by columns, inside a GTFS object
element.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

check_field_class(
  gtfs,
  "calendar",
  fields = c("monday", "tuesday"),
  classes = rep("integer", 2)
)

check_field_class(
  gtfs,
  "calendar",
  fields = c("monday", "tuesday"),
  classes = c("integer", "character")
)

}
\seealso{
Other checking functions: 
\code{\link{check_field_exists}()},
\code{\link{check_file_exists}()}
}
\concept{checking functions}
