% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_stop_id.R
\name{filter_by_stop_id}
\alias{filter_by_stop_id}
\title{Filter GTFS object by \code{stop_id}}
\usage{
filter_by_stop_id(gtfs, stop_id, keep = TRUE)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{stop_id}{A character vector. The \code{stop_id}s used to filter the data.}

\item{keep}{A logical. Whether the entries related to the \code{trip_id}s that
passes through the specified \code{stop_id}s should be kept or dropped (defaults
to \code{TRUE}, which keeps the entries).}
}
\value{
The GTFS object passed to the \code{gtfs} parameter, after the filtering
process.
}
\description{
Filters a GTFS object by \code{stop_id}s, keeping (or dropping) relevant entries
in each file. In order to keep the integrity of trips as described in the
\code{stop_times} table, the \code{stop_id}s are actually used to filter \code{trip_id}s,
which are then used to filter the rest of the GTFS object.
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)
stop_ids <- c("18848", "940004157")

object.size(gtfs)

# keeps entries related to trips that pass through specified stop_ids
smaller_gtfs <- filter_by_stop_id(gtfs, stop_ids)
object.size(smaller_gtfs)

# drops entries related to trips that pass through specified stop_ids
smaller_gtfs <- filter_by_stop_id(gtfs, stop_ids, keep = FALSE)
object.size(smaller_gtfs)

}
\seealso{
Other filtering functions: 
\code{\link{filter_by_agency_id}()},
\code{\link{filter_by_route_id}()},
\code{\link{filter_by_route_type}()},
\code{\link{filter_by_service_id}()},
\code{\link{filter_by_sf}()},
\code{\link{filter_by_shape_id}()},
\code{\link{filter_by_time_of_day}()},
\code{\link{filter_by_trip_id}()},
\code{\link{filter_by_weekday}()}
}
\concept{filtering functions}
