% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-calculate_summary_stat.R
\name{calculate_summary_stat}
\alias{calculate_summary_stat}
\title{This function takes in the meta data table, and calls the appropriate summarize function.}
\usage{
calculate_summary_stat(data, variable, by, summary_type, dichotomous_value,
  var_label, stat_display, digits, class, missing)
}
\arguments{
\item{data}{Data frame}

\item{variable}{Character variable name in \code{data} that will be tabulated}

\item{by}{Character variable name in\code{data} that Summary statistics for
\code{variable} are stratified}

\item{summary_type}{A list that includes specified summary types.}

\item{dichotomous_value}{If the output is dichotomous, then this is the value}

\item{var_label}{String label}

\item{stat_display}{String that specifies the format of the displayed statistics.
The syntax follows \code{glue::glue()} inputs with n, N, and p as input options.
of the variable that will be displayed.}

\item{digits}{integer indicating the number of decimal places to be used.}

\item{class}{variable class.  If class is NA, then all values are NA, and no
summary statistics will be calculated.}

\item{missing}{whether to include NA values in the table. \code{missing} controls
if the table includes counts of NA values: the allowed values correspond to
never ("no"), only if the count is positive ("ifany") and even for
zero counts ("always"). Default is "ifany".}
}
\description{
This function takes in the meta data table, and calls the appropriate summarize function.
}
\keyword{internal}
