% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_gtsummary.R
\name{theme_gtsummary}
\alias{theme_gtsummary}
\alias{theme_gtsummary_journal}
\alias{theme_gtsummary_compact}
\alias{theme_gtsummary_printer}
\alias{theme_gtsummary_language}
\alias{theme_gtsummary_continuous2}
\alias{theme_gtsummary_mean_sd}
\title{Available gtsummary themes}
\usage{
theme_gtsummary_journal(
  journal = c("jama", "nejm", "lancet"),
  set_theme = TRUE
)

theme_gtsummary_compact(set_theme = TRUE)

theme_gtsummary_printer(
  print_engine = c("gt", "kable", "kable_extra", "flextable", "huxtable", "tibble"),
  set_theme = TRUE
)

theme_gtsummary_language(
  language = c("de", "en", "es", "fr", "gu", "hi", "ja", "mr", "pt", "se", "zh-cn",
    "zh-tw"),
  decimal.mark = NULL,
  big.mark = NULL,
  iqr.sep = NULL,
  ci.sep = NULL,
  set_theme = TRUE
)

theme_gtsummary_continuous2(
  statistic = "{median} ({p25, {p75})",
  set_theme = TRUE
)

theme_gtsummary_mean_sd(set_theme = TRUE)
}
\arguments{
\item{journal}{String indicating the journal theme to follow.
\itemize{
\item \code{"jama"} Journal of the American Medical Association
\item \code{"nejm"} New England Journal of Medicine
\item \code{"lancet"} The Lancet
}}

\item{set_theme}{Logical indicating whether to set the theme. Default is \code{TRUE}.
When \code{FALSE} the named list of theme elements is returned invisibly}

\item{print_engine}{String indicating the print method. Must be one of
\code{"gt"}, \code{"kable"}, \code{"kable_extra"}, \code{"flextable"}, \code{"tibble"}#' @export}

\item{language}{String indicating language. Must be one of \code{"de"} (German),
\code{"en"} (English), \code{"es"} (Spanish), \code{"fr"} (French), \code{"gu"} (Gujarati),
\code{"hi"} (Hindi), \code{"ja"} (Japanese), \code{"mr"} (Marathi), \code{"pt"} (Portuguese),
\code{"se"} (Swedish), \code{"zh-cn"} (Chinese Simplified), \code{"zh-tw"} (Chinese Traditional)

If a language is missing a translation for a word or phrase, please feel free
to reach out on \href{https://github.com/ddsjoberg/gtsummary/issues}{GitHub}
with the translated text!}

\item{decimal.mark}{The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{big.mark}{Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{iqr.sep}{string indicating separator for the default IQR in \code{tbl_summary()}.
If \verb{decimal.mark=} is NULL, \verb{iqr.sep=} is \code{", "}. The comma
separator, however, can look odd when \code{decimal.mark = ","}. In this case the argument
will default to an en dash}

\item{ci.sep}{string indicating separator for confidence intervals.
If \verb{decimal.mark=} is NULL, \verb{ci.sep=} is \code{", "}. The comma
separator, however, can look odd when \code{decimal.mark = ","}. In this case the argument
will default to an en dash}

\item{statistic}{Default statistic continuous variables}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
The following themes are available to use within the gtsummary package.
Print theme elements with \code{theme_gtsummary_journal(set_theme = FALSE) \%>\% print()}.
Review the \href{http://www.danieldsjoberg.com/gtsummary/articles/themes.html}{themes vignette}
for details.
}
\section{Themes}{

\itemize{
\item \code{theme_gtsummary_journal(journal=)}
\itemize{
\item \code{"jama"} The Journal of the American Medical Association
\item \code{"nejm"} The New England Journal of Medicine
\item \code{"lancet"} The Lancet
}
\item \code{theme_gtsummary_compact()}
\itemize{
\item tables printed with gt, flextable, kableExtra, or huxtable will be compact with smaller font size and reduced cell padding
}
\item \code{theme_gtsummary_printer(print_engine=)}
\itemize{
\item \code{"gt"} sets the gt package as the default print engine
\item \code{"flextable"} sets the flextable package as the default print engine
\item \code{"huxtable"} sets the huxtable package as the default print engine
\item \code{"kable"} sets the \code{knitr::kable()} function as the default print engine
\item \code{"kable_extra"} sets the kableExtra package as the default print engine
\item \code{"tibble"} returns output as tibble
}
\item \code{theme_gtsummary_continuous2()}
\itemize{
\item Set all continuous variables to summary type \code{"continuous2"} by default
\item Use the \verb{statistic=} argument to set the default continuous variable summary statistics
}
\item \code{theme_gtsummary_mean_sd()}
\itemize{
\item Set default summary statistics to mean and standard deviation in \code{tbl_summary()}
\item Set default tests in \code{add_p.tbl_summary()} to t-tests and ANOVA
}
}

Use \code{reset_gtsummary_theme()} to restore the default settings

Review the \href{http://www.danieldsjoberg.com/gtsummary/articles/themes.html}{themes vignette}
to create your own themes.
}

\section{Example Output}{

\if{html}{Example}

\if{html}{\figure{set_gtsummary_theme_ex1.png}{options: width=70\%}}
}

\examples{
# Setting JAMA theme for gtsummary
theme_gtsummary_journal("jama")
# Themes can be combined by including more than one
theme_gtsummary_compact()

set_gtsummary_theme_ex1 <-
  trial \%>\%
  select(age, grade, trt) \%>\%
  tbl_summary(by = trt) \%>\%
  add_stat_label() \%>\%
  as_gt()

# reset gtsummary themes
reset_gtsummary_theme()
}
\seealso{
\href{http://www.danieldsjoberg.com/gtsummary/articles/themes.html}{Themes vignette}

\code{\link[=set_gtsummary_theme]{set_gtsummary_theme()}}, \code{\link[=reset_gtsummary_theme]{reset_gtsummary_theme()}}
}
