% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ci.R
\name{add_ci}
\alias{add_ci}
\alias{add_ci.tbl_summary}
\title{Add Proportion CIs}
\usage{
add_ci(x, ...)

\method{add_ci}{tbl_summary}(
  x,
  method = NULL,
  include = everything(),
  statistic = NULL,
  conf.level = 0.95,
  style_fun = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{tbl_summary} object}

\item{...}{Not used}

\item{method}{Confidence interval method. Default is
\code{list(all_categorical() ~ "wilson", all_continuous() ~ "t.test")}.
Must be one of
\code{c("wilson", "wilson.no.correct", "exact", "asymptotic")} for categorical
variables, and \code{c("t.test", "wilcox.test")} for continuous variables.
See details below.}

\item{include}{variables to include in the summary table. Default is \code{everything()}}

\item{statistic}{Formula indicating how the confidence interval will be displayed.
Default is \code{list(all_categorical() ~ "{conf.low}\%, {conf.high}\%", all_continuous() ~ "{conf.low}, {conf.high}")}}

\item{conf.level}{Confidence level. Default is \code{0.95}}

\item{style_fun}{Function to style upper and lower bound of confidence
interval. Default is
\code{list(all_categorical() ~ purrr::partial(style_sigfig, scale =  100), all_continuous() ~ style_sigfig)}.}
}
\value{
gtsummary table
}
\description{
Add a new column with the confidence intervals for proportions.
}
\section{method argument}{

Methods \code{c("wilson", "wilson.no.correct")} are calculated with
\code{prop.test(correct = c(TRUE, FALSE))}.
The default method, \code{"wilson"}, includes the Yates continuity correction.
Methods \code{c("exact", "asymptotic")} are calculated with \code{Hmisc::binconf(method=)}.
Confidence intervals for means are calculated using \code{t.test()} and
\code{wilcox.test()} for pseudo-medians.
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_ci_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{add_ci_ex2.png}{options: width=45\%}}
}

\examples{
# Example 1 ----------------------------------
add_ci_ex1 <-
  trial \%>\%
  select(age, response, trt) \%>\%
  tbl_summary(missing = "no",
              statistic = all_continuous() ~ "{mean} ({sd})") \%>\%
  add_ci()

# Example 2 ----------------------------------
add_ci_ex2 <-
  trial \%>\%
    select(response, trt) \%>\%
    tbl_summary(statistic = all_categorical() ~ "{p}\%",
                missing = "no") \%>\%
    add_ci() \%>\%
    modify_cols_merge(
      rows = !is.na(ci_stat_0),
      pattern = "{stat_0} ({ci_stat_0})"
    ) \%>\%
    modify_footnote(everything() ~ NA)
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n.tbl_summary}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify}},
\code{\link{separate_p_footnotes}()},
\code{\link{tbl_custom_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_summary}()}
}
\concept{tbl_summary tools}
