% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibble.gtsummary}
\alias{as_tibble.gtsummary}
\alias{as.data.frame.gtsummary}
\title{Convert gtsummary object to a tibble}
\usage{
\method{as_tibble}{gtsummary}(
  x,
  include = everything(),
  col_labels = TRUE,
  return_calls = FALSE,
  fmt_missing = FALSE,
  ...
)

\method{as.data.frame}{gtsummary}(...)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{col_labels}{Logical argument adding column labels to output tibble.
Default is \code{TRUE}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{fmt_missing}{Logical argument adding the missing value formats.}

\item{...}{Not used}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Function converts a gtsummary object to a tibble.
}
\examples{
\donttest{
tbl <-
  trial \%>\%
  select(trt, age, grade, response) \%>\%
  tbl_summary(by = trt)

as_tibble(tbl)

# without column labels
as_tibble(tbl, col_labels = FALSE)
}
}
\seealso{
Other gtsummary output types: 
\code{\link{as_flex_table}()},
\code{\link{as_gt}()},
\code{\link{as_hux_table}()},
\code{\link{as_kable_extra}()},
\code{\link{as_kable}()}
}
\author{
Daniel D. Sjoberg
}
\concept{gtsummary output types}
