% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-variants.R
\name{filter_variants_by_standard_chromosomes}
\alias{filter_variants_by_standard_chromosomes}
\title{Filter variants by standard human chromosomes.}
\usage{
filter_variants_by_standard_chromosomes(
  s4_variants,
  chromosomes = c(seq_len(22), "X", "Y", "MT")
)
}
\arguments{
\item{s4_variants}{An object of class \linkS4class{variants}.}

\item{chromosomes}{A character vector of valid chromosome names. Default is
autosomal chromosomes 1 thru 22 and, X, Y, and MT.}
}
\value{
An object of class \linkS4class{variants}.
}
\description{
This function filters a \linkS4class{variants} object by standard human chromosomes, i.e.,
1--22, X and Y. In addition to these chromosomes, some variants retrieved
from the GWAS Catalog might be also mapped to non-standard locations, such as
GRC assembly patches, haplotype (HAPs) or pseudo autosomal regions (PARs).
When this happens the main table \code{variants} includes rows for these
cases too. This function removes these.
}
\keyword{internal}
