% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwer.R
\name{gwer}
\alias{gwer}
\alias{print.gwer}
\title{Geographically Weighted Elliptical Regression}
\usage{
gwer(
  formula,
  data,
  regression.points,
  bandwidth,
  kernel = "bisquare",
  p = 2,
  theta = 0,
  adapt = NULL,
  hatmatrix = FALSE,
  family = Normal,
  longlat = NULL,
  dMat,
  weights,
  dispersion = NULL,
  subset,
  na.action = "na.fail",
  method = "gwer.fit",
  control = glm.control(epsilon = 1e-04, maxit = 100, trace = F),
  model = FALSE,
  x = FALSE,
  y = TRUE,
  contrasts = NULL,
  offset,
  spdisp = TRUE,
  parplot = FALSE,
  ...
)
}
\arguments{
\item{formula}{regression model formula as in \code{glm}.}

\item{data}{model data frame, or may be a SpatialPointsDataFrame or SpatialPolygonsDataFrame as defined in package \pkg{sp}.}

\item{regression.points}{a Spatial*DataFrame object, i.e. SpatialPointsDataFrame or SpatialPolygonsDataFrame as defined in package sp; Note that no diagnostic information will returned if it is assigned.}

\item{bandwidth}{value of the selected bandwidth used in the weighting function (see \code{bw.gwer} for bandwidth optimization).}

\item{kernel}{function chosen as follows:
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise;
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise}

\item{p}{the power of the Minkowski distance, default is 2, i.e. the Euclidean distance}

\item{theta}{an angle in radians to rotate the coordinate system, default is 0}

\item{adapt}{defines the type of bandwidth used. either NULL (default) or a proportion between 0 and 1 of observations to include in weighting scheme (k-nearest neighbours).}

\item{hatmatrix}{if TRUE, return the hatmatrix as a component of the result.}

\item{family}{a description of the error distribution to be used in the model (see \code{\link{family.elliptical}} for details of family functions).}

\item{longlat}{TRUE if point coordinates are longitude-latitude decimal degrees, in which case distances are measured in kilometers. If x is a SpatialPoints object, the value is taken from the object itself.}

\item{dMat}{a pre-specified distance matrix, it can be calculated by the function gw.dist}

\item{weights}{an optional numeric vector of weights to be used in the fitting process.}

\item{dispersion}{an optional fixed value for dispersion parameter.}

\item{subset}{an optional numeric vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs (see \code{glm}).}

\item{method}{the method to be used in fitting local models. The default method "bw.gwer" uses Fisher's scoring method. The alternative "model.frame" returns the model frame and does no fitting.}

\item{control}{a list of parameters for controlling the fitting process. For \code{elliptical} this is passed by \code{glm.control}.}

\item{model}{a logical value indicating whether model frame should be included as a component of the return.}

\item{x}{a logical value indicating whether the response vector used in the fitting process should be returned as components of the return.}

\item{y}{a logical value indicating whether model matrix used in the fitting process should be returned as components of the return.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \code{model.matrix.default}.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting as in \code{glm}.}

\item{spdisp}{if TRUE dispersion parameter varies geographically.}

\item{parplot}{if TRUE the parameters boxplots are plotted.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \dQuote{gwer}, a list with follow components:   
\item{SDF}{a SpatialPointsDataFrame (may be gridded) or SpatialPolygonsDataFrame object (see package \pkg{sp}) with fit.points, weights, GWR coefficient estimates, dispersion and the residuals in its \code{data} slot.}
\item{coef}{the matrices of coefficients, standard errors and significance values for parameters hypothesis test.}
\item{dispersion}{either the supplied argument or the estimated dispersion with standard error.}
\item{hat}{hat matrix of the geographically weighted elliptical model.}
\item{lm}{elliptical global regression on the same model formula.}  
\item{results}{a list of results values for fitted geographically weighted elliptical model.}  
\item{bandwidth}{the bandwidth used in geographical weighting function.}
\item{fitted}{the fitted mean values of the geographically weighted elliptical model.}
\item{hatmatrix}{a logical value indicating if hatmatrix was considered}
\item{gweights}{a matrix with the geographical weighting for all local elliptical models.}
\item{family}{the \code{family} object used.}
\item{flm}{a matrix with the fitted values for all local elliptical models.}
\item{adapt}{the \code{adapt} object used.}
\item{kernel}{the \code{kernel} object used.}
\item{spdisp}{the \code{spdisp} object used.}
\item{this.call}{the function call used.}
\item{longlat}{the \code{longlat} object used.}
}
\description{
The function fit geographically weighted elliptical regression  model to explore the non-stationarity for a certain bandwidth and  weighting function.
}
\examples{
\donttest{
data(georgia, package = "spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.t <- bw.gwer(fit.formula, data = gSRDF, family = Student(3), adapt = TRUE)
gwer.fit.t <- gwer(fit.formula, data = gSRDF, family = Student(3), bandwidth = gwer.bw.t, 
                   adapt = TRUE, parplot = FALSE, hatmatrix = TRUE, spdisp = TRUE, 
                   method = "gwer.fit")
print(gwer.fit.t) 
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \doi{10.1111/j.1538-4632.1996.tb00936.x}

Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\doi{10.1016/j.spl.2007.01.012}

Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{bw.gwer}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{Bandwidth}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{model}
\keyword{optimization}
\keyword{regression}
\keyword{weighted}
