\name{h2o.SpeeDRF}
\alias{h2o.SpeeDRF}
\title{
H2O: Single-Node Random Forest
}
\description{
Performs single-node random forest classification on a data set.
}
\usage{
h2o.SpeeDRF(x, y, data, key = "", classification = TRUE, nfolds = 0, validation, 
  mtries = -1, ntree = 50, depth = 20, sample.rate = 2/3, oobee = TRUE, 
  importance = FALSE, nbins = 1024, seed = -1, stat.type = "ENTROPY", 
  balance.classes = FALSE, verbose = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
A vector containing the names or indices of the predictor variables to use in building the random forest model.
}
  \item{y}{
The name or index of the response variable. If the data does not contain a header, this is the column index, designated by increasing numbers from left to right. (The response must be either an integer or a categorical variable).
}
  \item{data}{
An \code{\linkS4class{H2OParsedData}} object containing the variables in the model.
}
  \item{key}{
(Optional) The unique hex key assigned to the resulting model. If none is given, a key will automatically be generated.
}
  \item{classification}{
(Optional) A logical value indicating whether a classification model should be built (as opposed to regression).
  }
    \item{nfolds}{
  (Optional) Number of folds for cross-validation. If \code{nfolds >= 2}, then \code{validation} must remain empty.
}
  \item{validation}{
  (Optional) An \code{\linkS4class{H2OParsedData}} object indicating the validation dataset used to construct confusion matrix. If left blank, this defaults to the training data when \code{nfolds = 0}.}
  \item{mtries}{
  (Optional) Number of features to randomly select at each split in the tree. If set to the default of -1, this will be set to \code{sqrt(ncol(data))}, rounded down to the nearest integer.
  }
  \item{ntree}{
(Optional) Number of trees to grow. (Must be a nonnegative integer).
  }
  \item{depth}{
  (Optional) Maximum depth to grow the tree.
  }
  \item{sample.rate}{
  (Optional) Sampling rate for constructing data from which individual trees are grown.
  }
  \item{oobee}{
  (Optional) A logical value indicating whether to calculate the out of bag error estimate.
  }
  \item{importance}{
  (Optional) A logical value indicating whether to compute variable importance measures. (If set to \code{TRUE}, the algorithm will take longer to finish.)
  }
  \item{nbins}{
  (Optional) Build a histogram of this many bins, then split at best point.
  }
  \item{seed}{
  (Optional) Seed for building the random forest. If \code{seed = -1}, one will automatically be generated by H2O.
  }
  \item{stat.type}{
  (Optional) Type of statistic to use, equal to either "ENTROPY" or "GINI".
  }
  \item{balance.classes}{
  (Optional) A logical value indicating whether classes should be rebalanced. Use for datasets where the levels of the response class are very unbalanced.
  }
  \item{verbose}{
  (Optional) A logical value indicating whether verbose results should be returned.
  }
}

\details{
IMPORTANT: Currently, you must initialize H2O with the flag \code{beta = TRUE} in \code{h2o.init} in order to use this method!

This method runs random forest model building on a single node, as opposed to the multi-node implementation in \code{\link{h2o.randomForest}}.
}

\value{
An object of class \code{\linkS4class{H2OSpeeDRFModel}} with slots key, data, valid (the validation dataset), and model, where the last is a list of the following components:
\item{params }{Input parameters for building the model.}
\item{ntree }{Number of trees grown.}
\item{depth }{Depth of the trees grown.}
\item{nbins }{Number of bins used in building the histogram.}
\item{classification }{Logical value indicating if the model is classification.}
\item{mse }{Mean-squared error for each tree.}
\item{confusion }{Confusion matrix of the prediction.}
}

\seealso{
\code{\linkS4class{H2OSpeeDRFModel}}, \code{\link{h2o.randomForest}}
}

\examples{
\dontrun{
library(h2o)
localH2O = h2o.init()
irisPath = system.file("extdata", "iris.csv", package = "h2o")
iris.hex = h2o.importFile(localH2O, path = irisPath, key = "iris.hex")
h2o.SpeeDRF(x = c(2,3,4), y = 5, data = iris.hex, ntree = 50, depth = 100)
}
}
