% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.sd}
\alias{h2o.sd}
\alias{sd,H2OFrame-method}
\title{Standard Deviation of a column of data.}
\usage{
\S4method{sd}{H2OFrame}(x, na.rm = FALSE)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}

\item{na.rm}{\code{logical}. Should missing values be removed?}
}
\description{
Obtain the standard deviation of a column of data.
}
\examples{
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
sd(prostate.hex$AGE)
}
\seealso{
\code{\link{h2o.var}} for variance, and \code{\link[stats]{sd}} for the base R implementation.
}

