% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.substring}
\alias{h2o.substr}
\alias{h2o.substring}
\title{Substring}
\usage{
h2o.substring(x, start, stop = "[]")

h2o.substr(x, start, stop = "[]")
}
\arguments{
\item{x}{The column on which to operate.}

\item{start}{The index of the first element to be included in the substring.}

\item{stop}{Optional, The index of the last element to be included in the substring.}
}
\description{
Returns a copy of the target column that is a substring at the specified start
and stop indices, inclusive. If the stop index is not specified, then the substring extends
to the end of the original string. If start is longer than the number of characters
in the original string, or is greater than stop, an empty string is returned. Negative start
is coerced to 0.
}
\examples{
\donttest{
library(h2o)
h2o.init()
string_to_substring <- as.h2o("1234567890")
substr <- h2o.substring(string_to_substring,2) #Get substring from second index onwards
}
}

