% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.fillna}
\alias{h2o.fillna}
\title{fillNA}
\usage{
h2o.fillna(x, method = "forward", axis = 1, maxlen = 1L)
}
\arguments{
\item{x}{an H2OFrame}

\item{method}{A String: "forward" or "backward"}

\item{axis}{An Integer 1 for row-wise fill (default), 2 for column-wise fill}

\item{maxlen}{An Integer for maximum number of consecutive NA's to fill}
}
\value{
An H2OFrame after filling missing values
}
\description{
Fill NA's in a sequential manner up to a specified limit
}
\examples{
\donttest{
library(h2o)
h2o.init()
fr.with.nas = h2o.createFrame(categorical_fraction=0.0,missing_fraction=0.7,rows=6,cols=2,seed=123)
fr <- h2o.fillna(fr.with.nas, "forward", axis=1, maxlen=2L)
}
}

