% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.parseRaw}
\alias{h2o.parseRaw}
\title{H2O Data Parsing}
\usage{
h2o.parseRaw(data, pattern = "", destination_frame = "", header = NA,
  sep = "", col.names = NULL, col.types = NULL, na.strings = NULL,
  blocking = FALSE, parse_type = NULL, chunk_size = NULL)
}
\arguments{
\item{data}{An H2OFrame object to be parsed.}

\item{pattern}{(Optional) Character string containing a regular expression to match file(s) in
the folder.}

\item{destination_frame}{(Optional) The hex key assigned to the parsed file.}

\item{header}{(Optional) A logical value indicating whether the first row is
the column header. If missing, H2O will automatically try to detect
the presence of a header.}

\item{sep}{(Optional) The field separator character. Values on each line of
the file are separated by this character. If \code{sep = ""}, the
parser will automatically detect the separator.}

\item{col.names}{(Optional) An H2OFrame object containing a
single delimited line with the column names for the file.}

\item{col.types}{(Optional) A vector specifying the types to attempt to force
over columns.}

\item{na.strings}{(Optional) H2O will interpret these strings as missing.}

\item{blocking}{(Optional) Tell H2O parse call to block synchronously instead
of polling.  This can be faster for small datasets but loses the
progress bar.}

\item{parse_type}{(Optional) Specify which parser type H2O will use.
Valid types are "ARFF", "XLS", "CSV", "SVMLight"}

\item{chunk_size}{size of chunk of (input) data in bytes}
}
\description{
The second phase in the data ingestion step.
}
\details{
Parse the Raw Data produced by the import phase.
}
\seealso{
\link{h2o.importFile}, \link{h2o.parseSetup}
}

