% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/glrm.R
\name{h2o.proj_archetypes}
\alias{h2o.proj_archetypes}
\title{Convert Archetypes to Features from H2O GLRM Model}
\usage{
h2o.proj_archetypes(object, data, reverse_transform = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2ODimReductionModel} object that represents the
model containing archetypes to be projected.}

\item{data}{An H2OFrame object representing the training data for the H2O GLRM model.}

\item{reverse_transform}{(Optional) A logical value indicating whether to reverse the
transformation from model-building by re-scaling columns and adding back the
offset to each column of the projected archetypes.}
}
\value{
Returns an H2OFrame object containing the projection of the archetypes
        down into the original feature space, where each row is one archetype.
}
\description{
Project each archetype in an H2O GLRM model into the corresponding feature
space from the H2O training frame.
}
\examples{
\donttest{
library(h2o)
h2o.init()
irisPath <- system.file("extdata", "iris_wheader.csv", package="h2o")
iris.hex <- h2o.uploadFile(path = irisPath)
iris.glrm <- h2o.glrm(training_frame = iris.hex, k = 4, loss = "Quadratic",
                      multi_loss = "Categorical", max_iterations = 1000)
iris.parch <- h2o.proj_archetypes(iris.glrm, iris.hex)
head(iris.parch)
}
}
\seealso{
\code{\link{h2o.glrm}} for making an H2ODimReductionModel.
}

