% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{h2o.connect}
\alias{h2o.connect}
\title{Connect to a running H2O instance.}
\usage{
h2o.connect(ip = "localhost", port = 54321, strict_version_check = TRUE,
  proxy = NA_character_, https = FALSE, insecure = FALSE,
  username = NA_character_, password = NA_character_,
  cookies = NA_character_, context_path = NA_character_, config = NULL)
}
\arguments{
\item{ip}{Object of class \code{character} representing the IP address of the server where H2O is running.}

\item{port}{Object of class \code{numeric} representing the port number of the H2O server.}

\item{strict_version_check}{(Optional) Setting this to FALSE is unsupported and should only be done when advised by technical support.}

\item{proxy}{(Optional) A \code{character} string specifying the proxy path.}

\item{https}{(Optional) Set this to TRUE to use https instead of http.}

\item{insecure}{(Optional) Set this to TRUE to disable SSL certificate checking.}

\item{username}{(Optional) Username to login with.}

\item{password}{(Optional) Password to login with.}

\item{cookies}{(Optional) Vector(or list) of cookies to add to request.}

\item{context_path}{(Optional) The last part of connection URL: http://<ip>:<port>/<context_path>}

\item{config}{(Optional) A \code{list} describing connection parameters.}
}
\value{
an instance of \code{H2OConnection} object representing a connection to the running H2O instance.
}
\description{
Connect to a running H2O instance.
}
\examples{
\dontrun{
library(h2o)
# Try to connect to a H2O instance running at http://localhost:54321/cluster_X
# If not found, start a local H2O instance from R with the default settings.
#h2o.connect(ip = "localhost", port = 54321, context_path = "cluster_X")
# Or
#config = list(ip = "localhost", port = 54321, context_path = "cluster_X")
#h2o.connect(config = config)

# Skip strict version check during connecting to the instance
#h2o.connect(config = c(strict_version_check = FALSE, config))
}
}
