% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{h2o.coxph}
\alias{h2o.coxph}
\title{Trains a Cox Proportional Hazards Model (CoxPH) on an H2O dataset}
\usage{
h2o.coxph(x, event_column, training_frame, model_id = NULL,
  start_column = NULL, stop_column = NULL, weights_column = NULL,
  offset_column = NULL, ties = c("efron", "breslow"), init = 0,
  lre_min = 9, iter_max = 20)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except event_column, start_column and stop_column are used.}

\item{event_column}{The name of binary data column in the training frame indicating the occurrence of an event.}

\item{training_frame}{Id of the training data frame.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{start_column}{start_column}

\item{stop_column}{stop_column}

\item{weights_column}{Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.}

\item{offset_column}{Offset column. This will be added to the combination of columns before applying the link function.}

\item{ties}{ties Must be one of: "efron", "breslow". Defaults to efron.}

\item{init}{init Defaults to 0.}

\item{lre_min}{lre_min Defaults to 9.}

\item{iter_max}{iter_max Defaults to 20.}
}
\description{
Trains a Cox Proportional Hazards Model (CoxPH) on an H2O dataset
}
