% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.match}
\alias{\%in\%}
\alias{h2o.match}
\alias{match.H2OFrame}
\title{Value Matching in H2O}
\usage{
h2o.match(x, table, nomatch = 0, incomparables = NULL)

match.H2OFrame(x, table, nomatch = 0, incomparables = NULL)

x \%in\% table
}
\arguments{
\item{x}{a categorical vector from an H2OFrame object with
values to be matched.}

\item{table}{an R object to match \code{x} against.}

\item{nomatch}{the value to be returned in the case when no match is found.}

\item{incomparables}{a vector of calues that cannot be matched. Any value in
\code{x} matching a value in this vector is assigned the
\code{nomatch} value.}
}
\value{
Returns a vector of the positions of (first) matches of its first argument in its second
}
\description{
\code{match} and \code{\%in\%} return values similar to the base R generic
functions.
}
\examples{
\donttest{
h2o.init()
hex <- as.h2o(iris)
h2o.match(hex[,5], c("setosa", "versicolor"))
}
}
\seealso{
\code{\link[base]{match}} for base R implementation.
}

