% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.randomForest}
\alias{h2o.randomForest}
\title{Build a Big Data Random Forest Model}
\usage{
h2o.randomForest(x, y, training_frame, model_id, validation_frame, checkpoint,
  mtries = -1, sample_rate = 0.632, build_tree_one_node = FALSE,
  ntrees = 50, max_depth = 20, min_rows = 1, nbins = 20,
  nbins_cats = 1024, binomial_double_trees = FALSE,
  balance_classes = FALSE, max_after_balance_size = 5, seed,
  offset_column = NULL, weights_column = NULL, nfolds = 0,
  fold_column = NULL, fold_assignment = c("AUTO", "Random", "Modulo"),
  keep_cross_validation_predictions = FALSE, ...)
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables
to use in building the GBM model.}

\item{y}{The name or index of the response variable. If the data does not
contain a header, this is the column index number starting at 1, and
increasing from left to right. (The response must be either an integer
or a categorical variable).}

\item{training_frame}{An \code{\linkS4class{H2OFrame}} object containing the
variables in the model.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If
none is given, an id will automatically be generated.}

\item{validation_frame}{An \code{\linkS4class{H2OFrame}} object containing the variables in the model.}

\item{checkpoint}{"Model checkpoint (either key or H2ODeepLearningModel) to resume training with."}

\item{mtries}{Number of variables randomly sampled as candidates at each split.
If set to -1, defaults to sqrt{p} for classification, and p/3 for regression,
where p is the number of predictors.}

\item{sample_rate}{Sample rate, from 0 to 1.0.}

\item{build_tree_one_node}{Run on one node only; no network overhead but
fewer cpus used.  Suitable for small datasets.}

\item{ntrees}{A nonnegative integer that determines the number of trees to
grow.}

\item{max_depth}{Maximum depth to grow the tree.}

\item{min_rows}{Minimum number of rows to assign to teminal nodes.}

\item{nbins}{For numerical columns (real/int), build a histogram of this many bins, then split at the best point.}

\item{nbins_cats}{For categorical columns (enum), build a histogram of this many bins, then split at the best point.
Higher values can lead to more overfitting.}

\item{binomial_double_trees}{For binary classification: Build 2x as many trees (one per class) - can lead to higher accuracy.}

\item{balance_classes}{logical, indicates whether or not to balance training
data class counts via over/under-sampling (for imbalanced data)}

\item{max_after_balance_size}{Maximum relative size of the training data after balancing class counts (can be less
than 1.0)}

\item{seed}{Seed for random numbers (affects sampling) - Note: only
reproducible when running single threaded}

\item{offset_column}{Specify the offset column.}

\item{weights_column}{Specify the weights column.}

\item{nfolds}{(Optional) Number of folds for cross-validation. If \code{nfolds >= 2}, then \code{validation} must remain empty.}

\item{fold_column}{(Optional) Column with cross-validation fold index assignment per observation}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified
Must be "AUTO", "Random" or "Modulo"}

\item{keep_cross_validation_predictions}{Whether to keep the predictions of the cross-validation models}

\item{...}{(Currently Unimplemented)}
}
\value{
Creates a \linkS4class{H2OModel} object of the right type.
}
\description{
Builds a Random Forest Model on an \linkS4class{H2OFrame}
}
\seealso{
\code{\link{predict.H2OModel}} for prediction.
}

