% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.setLevels}
\alias{h2o.setLevels}
\title{Set Levels of H2O Factor Column}
\usage{
h2o.setLevels(x, levels, in.place = TRUE)
}
\arguments{
\item{x}{A single categorical column.}

\item{levels}{A character vector specifying the new levels. The number of new levels must match the number of old levels.}

\item{in.place}{Indicates whether new domain will be directly applied to the column (in place change) or if a copy
of the column will be created with the given domain levels.}
}
\description{
Works on a single categorical vector. New domains must be aligned with the old domains.
This call has SIDE EFFECTS and mutates the column in place (change of the levels will also affect all the frames
that are referencing this column). If you want to make a copy of the column instead, use parameter in.place = FALSE.
}
\examples{
\donttest{
h2o.init()
iris.hex <- as.h2o(iris)
new.levels <- c("setosa", "versicolor", "caroliniana")
iris.hex$Species <- h2o.setLevels(iris.hex$Species, new.levels, in.place = FALSE)
h2o.levels(iris.hex$Species)
}
}
