% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automl.R
\name{h2o.getAutoML}
\alias{h2o.getAutoML}
\title{Get an R object that is a subclass of \linkS4class{H2OAutoML}}
\usage{
h2o.getAutoML(project_name)
}
\arguments{
\item{project_name}{A string indicating the project_name of the automl instance to retrieve.}
}
\value{
Returns an object that is a subclass of \linkS4class{H2OAutoML}.
}
\description{
Get an R object that is a subclass of \linkS4class{H2OAutoML}
}
\examples{
\dontrun{
library(h2o)
h2o.init()
votes_path <- system.file("extdata", "housevotes.csv", package = "h2o")
votes_hf <- h2o.uploadFile(path = votes_path, header = TRUE)
aml <- h2o.automl(y = "Class", project_name="aml_housevotes",
                  training_frame = votes_hf, max_runtime_secs = 30)
automl_retrieved <- h2o.getAutoML("aml_housevotes")
}
}
