% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomforest.R
\name{h2o.randomForest}
\alias{h2o.randomForest}
\title{Build a Random Forest model}
\usage{
h2o.randomForest(x, y, training_frame, model_id = NULL,
  validation_frame = NULL, nfolds = 0,
  keep_cross_validation_models = TRUE,
  keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE,
  score_each_iteration = FALSE, score_tree_interval = 0,
  fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
  fold_column = NULL, ignore_const_cols = TRUE, offset_column = NULL,
  weights_column = NULL, balance_classes = FALSE,
  class_sampling_factors = NULL, max_after_balance_size = 5,
  max_hit_ratio_k = 0, ntrees = 50, max_depth = 20, min_rows = 1,
  nbins = 20, nbins_top_level = 1024, nbins_cats = 1024,
  r2_stopping = Inf, stopping_rounds = 0, stopping_metric = c("AUTO",
  "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC",
  "lift_top_group", "misclassification", "AUCPR", "mean_per_class_error",
  "custom", "custom_increasing"), stopping_tolerance = 0.001,
  max_runtime_secs = 0, seed = -1, build_tree_one_node = FALSE,
  mtries = -1, sample_rate = 0.6320000291,
  sample_rate_per_class = NULL, binomial_double_trees = FALSE,
  checkpoint = NULL, col_sample_rate_change_per_level = 1,
  col_sample_rate_per_tree = 1, min_split_improvement = 1e-05,
  histogram_type = c("AUTO", "UniformAdaptive", "Random",
  "QuantilesGlobal", "RoundRobin"), categorical_encoding = c("AUTO",
  "Enum", "OneHotInternal", "OneHotExplicit", "Binary", "Eigen",
  "LabelEncoder", "SortByResponse", "EnumLimited"),
  calibrate_model = FALSE, calibration_frame = NULL,
  distribution = c("AUTO", "bernoulli", "multinomial", "gaussian",
  "poisson", "gamma", "tweedie", "laplace", "quantile", "huber"),
  custom_metric_func = NULL, export_checkpoints_dir = NULL,
  check_constant_response = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except y are used.}

\item{y}{The name or column index of the response variable in the data. The response must be either a numeric or a
categorical/factor variable. If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.}

\item{training_frame}{Id of the training data frame.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{nfolds}{Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.}

\item{keep_cross_validation_models}{\code{Logical}. Whether to keep the cross-validation models. Defaults to TRUE.}

\item{keep_cross_validation_predictions}{\code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.}

\item{keep_cross_validation_fold_assignment}{\code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{score_tree_interval}{Score the model after every so many trees. Disabled if set to 0. Defaults to 0.}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
"Random", "Modulo", "Stratified". Defaults to AUTO.}

\item{fold_column}{Column with cross-validation fold index assignment per observation.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{offset_column}{Offset column. This argument is deprecated and has no use for Random Forest.}

\item{weights_column}{Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
well. During training, rows with higher weights matter more, due to the larger loss function pre-factor.}

\item{balance_classes}{\code{Logical}. Balance training data class counts via over/under-sampling (for imbalanced data). Defaults to
FALSE.}

\item{class_sampling_factors}{Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
be automatically computed to obtain class balance during training. Requires balance_classes.}

\item{max_after_balance_size}{Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
balance_classes. Defaults to 5.0.}

\item{max_hit_ratio_k}{Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable)
Defaults to 0.}

\item{ntrees}{Number of trees. Defaults to 50.}

\item{max_depth}{Maximum tree depth. Defaults to 20.}

\item{min_rows}{Fewest allowed (weighted) observations in a leaf. Defaults to 1.}

\item{nbins}{For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the best point
Defaults to 20.}

\item{nbins_top_level}{For numerical columns (real/int), build a histogram of (at most) this many bins at the root level, then
decrease by factor of two per level Defaults to 1024.}

\item{nbins_cats}{For categorical columns (factors), build a histogram of this many bins, then split at the best point. Higher
values can lead to more overfitting. Defaults to 1024.}

\item{r2_stopping}{r2_stopping is no longer supported and will be ignored if set - please use stopping_rounds, stopping_metric
and stopping_tolerance instead. Previous version of H2O would stop making trees when the R^2 metric equals or
exceeds this Defaults to 1.797693135e+308.}

\item{stopping_rounds}{Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 0.}

\item{stopping_metric}{Metric to use for early stopping (AUTO: logloss for classification, deviance for regression and
anonomaly_score for Isolation Forest). Note that custom and custom_increasing can only be used in GBM and DRF
with the Python client. Must be one of: "AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC",
"lift_top_group", "misclassification", "AUCPR", "mean_per_class_error", "custom", "custom_increasing".
Defaults to AUTO.}

\item{stopping_tolerance}{Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
much) Defaults to 0.001.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default)
Defaults to -1 (time-based random number).}

\item{build_tree_one_node}{\code{Logical}. Run on one node only; no network overhead but fewer cpus used.  Suitable for small datasets.
Defaults to FALSE.}

\item{mtries}{Number of variables randomly sampled as candidates at each split. If set to -1, defaults to sqrt{p} for
classification and p/3 for regression (where p is the # of predictors Defaults to -1.}

\item{sample_rate}{Row sample rate per tree (from 0.0 to 1.0) Defaults to 0.6320000291.}

\item{sample_rate_per_class}{A list of row sample rates per class (relative fraction for each class, from 0.0 to 1.0), for each tree}

\item{binomial_double_trees}{\code{Logical}. For binary classification: Build 2x as many trees (one per class) - can lead to higher
accuracy. Defaults to FALSE.}

\item{checkpoint}{Model checkpoint to resume training with.}

\item{col_sample_rate_change_per_level}{Relative change of the column sampling rate for every level (must be > 0.0 and <= 2.0) Defaults to 1.}

\item{col_sample_rate_per_tree}{Column sample rate per tree (from 0.0 to 1.0) Defaults to 1.}

\item{min_split_improvement}{Minimum relative improvement in squared error reduction for a split to happen Defaults to 1e-05.}

\item{histogram_type}{What type of histogram to use for finding optimal split points Must be one of: "AUTO", "UniformAdaptive",
"Random", "QuantilesGlobal", "RoundRobin". Defaults to AUTO.}

\item{categorical_encoding}{Encoding scheme for categorical features Must be one of: "AUTO", "Enum", "OneHotInternal", "OneHotExplicit",
"Binary", "Eigen", "LabelEncoder", "SortByResponse", "EnumLimited". Defaults to AUTO.}

\item{calibrate_model}{\code{Logical}. Use Platt Scaling to calculate calibrated class probabilities. Calibration can provide more
accurate estimates of class probabilities. Defaults to FALSE.}

\item{calibration_frame}{Calibration frame for Platt Scaling}

\item{distribution}{Distribution. This argument is deprecated and has no use for Random Forest.}

\item{custom_metric_func}{Reference to custom evaluation function, format: `language:keyName=funcName`}

\item{export_checkpoints_dir}{Automatically export generated models to this directory.}

\item{check_constant_response}{\code{Logical}. Check if response column is constant. If enabled, then an exception is thrown if the response
column is a constant value.If disabled, then model will train regardless of the response column being a
constant value or not. Defaults to TRUE.}

\item{verbose}{\code{Logical}. Print scoring history to the console (Metrics per tree for GBM, DRF, & XGBoost. Metrics per epoch for Deep Learning). Defaults to FALSE.}
}
\value{
Creates a \linkS4class{H2OModel} object of the right type.
}
\description{
Builds a Random Forest model on an H2OFrame.
}
\seealso{
\code{\link{predict.H2OModel}} for prediction
}
