% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.coef_norm}
\alias{h2o.coef_norm}
\title{Return coefficients fitted on the standardized data (requires standardize = True, which is on by default). These coefficients can be used to evaluate variable importance.}
\usage{
h2o.coef_norm(object)
}
\arguments{
\item{object}{an \linkS4class{H2OModel} object.}
}
\description{
Return coefficients fitted on the standardized data (requires standardize = True, which is on by default). These coefficients can be used to evaluate variable importance.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement","power","weight","acceleration","year")
response <- "cylinders"
cars.split <- h2o.splitFrame(data = cars,ratios = 0.8, seed = 1234)
train <- cars.split[[1]]
valid <- cars.split[[2]]
cars_glm <- h2o.glm(balance_classes = TRUE, 
                    seed = 1234, 
                    x = predictors, 
                    y = response, 
                    training_frame = train, 
                    validation_frame = valid)
h2o.coef(cars_glm)
}
}
