% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.num_iterations}
\alias{h2o.num_iterations}
\title{Retrieve the number of iterations.}
\usage{
h2o.num_iterations(object)
}
\arguments{
\item{object}{An \linkS4class{H2OClusteringModel} object.}
}
\description{
Retrieve the number of iterations.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(prostate_path)
prostate[,2] <- as.factor(prostate[,2])
prostate_glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"), 
                        training_frame = prostate, family = "binomial", 
                        nfolds = 0, alpha = 0.5, lambda_search = FALSE)
h2o.num_iterations(prostate_glm)
}
}
