% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.print}
\alias{h2o.print}
\title{Print An H2OFrame}
\usage{
h2o.print(x, n = 6L)
}
\arguments{
\item{x}{An H2OFrame object}

\item{n}{An (Optional) A single integer. If positive, number of rows in x to return. If negative, all but the n first/last number of rows in x.
Anything bigger than 20 rows will require asking the server (first 20 rows are cached on the client).}
}
\description{
Print An H2OFrame
}
\examples{
\dontrun{
library()
h2o.init()

f <- "http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv"
iris <- h2o.importFile(f)
h2o.print(iris["species"], n = 15)
}
}
