% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glrm.R
\name{h2o.glrm}
\alias{h2o.glrm}
\title{Generalized low rank decomposition of an H2O data frame}
\usage{
h2o.glrm(
  training_frame,
  cols = NULL,
  model_id = NULL,
  validation_frame = NULL,
  ignore_const_cols = TRUE,
  score_each_iteration = FALSE,
  representation_name = NULL,
  loading_name = NULL,
  transform = c("NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE"),
  k = 1,
  loss = c("Quadratic", "Absolute", "Huber", "Poisson", "Hinge", "Logistic",
    "Periodic"),
  loss_by_col = c("Quadratic", "Absolute", "Huber", "Poisson", "Hinge", "Logistic",
    "Periodic", "Categorical", "Ordinal"),
  loss_by_col_idx = NULL,
  multi_loss = c("Categorical", "Ordinal"),
  period = 1,
  regularization_x = c("None", "Quadratic", "L2", "L1", "NonNegative", "OneSparse",
    "UnitOneSparse", "Simplex"),
  regularization_y = c("None", "Quadratic", "L2", "L1", "NonNegative", "OneSparse",
    "UnitOneSparse", "Simplex"),
  gamma_x = 0,
  gamma_y = 0,
  max_iterations = 1000,
  max_updates = 2000,
  init_step_size = 1,
  min_step_size = 1e-04,
  seed = -1,
  init = c("Random", "SVD", "PlusPlus", "User"),
  svd_method = c("GramSVD", "Power", "Randomized"),
  user_y = NULL,
  user_x = NULL,
  expand_user_y = TRUE,
  impute_original = FALSE,
  recover_svd = FALSE,
  max_runtime_secs = 0,
  export_checkpoints_dir = NULL
)
}
\arguments{
\item{training_frame}{Id of the training data frame.}

\item{cols}{(Optional) A vector containing the data columns on which k-means operates.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{representation_name}{Frame key to save resulting X}

\item{loading_name}{[Deprecated] Use representation_name instead.  Frame key to save resulting X.}

\item{transform}{Transformation of training data Must be one of: "NONE", "STANDARDIZE", "NORMALIZE", "DEMEAN", "DESCALE".
Defaults to NONE.}

\item{k}{Rank of matrix approximation Defaults to 1.}

\item{loss}{Numeric loss function Must be one of: "Quadratic", "Absolute", "Huber", "Poisson", "Hinge", "Logistic",
"Periodic". Defaults to Quadratic.}

\item{loss_by_col}{Loss function by column (override) Must be one of: "Quadratic", "Absolute", "Huber", "Poisson", "Hinge",
"Logistic", "Periodic", "Categorical", "Ordinal".}

\item{loss_by_col_idx}{Loss function by column index (override)}

\item{multi_loss}{Categorical loss function Must be one of: "Categorical", "Ordinal". Defaults to Categorical.}

\item{period}{Length of period (only used with periodic loss function) Defaults to 1.}

\item{regularization_x}{Regularization function for X matrix Must be one of: "None", "Quadratic", "L2", "L1", "NonNegative",
"OneSparse", "UnitOneSparse", "Simplex". Defaults to None.}

\item{regularization_y}{Regularization function for Y matrix Must be one of: "None", "Quadratic", "L2", "L1", "NonNegative",
"OneSparse", "UnitOneSparse", "Simplex". Defaults to None.}

\item{gamma_x}{Regularization weight on X matrix Defaults to 0.}

\item{gamma_y}{Regularization weight on Y matrix Defaults to 0.}

\item{max_iterations}{Maximum number of iterations Defaults to 1000.}

\item{max_updates}{Maximum number of updates, defaults to 2*max_iterations Defaults to 2000.}

\item{init_step_size}{Initial step size Defaults to 1.}

\item{min_step_size}{Minimum step size Defaults to 0.0001.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default).
Defaults to -1 (time-based random number).}

\item{init}{Initialization mode Must be one of: "Random", "SVD", "PlusPlus", "User". Defaults to PlusPlus.}

\item{svd_method}{Method for computing SVD during initialization (Caution: Randomized is currently experimental and unstable)
Must be one of: "GramSVD", "Power", "Randomized". Defaults to Randomized.}

\item{user_y}{User-specified initial Y}

\item{user_x}{User-specified initial X}

\item{expand_user_y}{\code{Logical}. Expand categorical columns in user-specified initial Y Defaults to TRUE.}

\item{impute_original}{\code{Logical}. Reconstruct original training data by reversing transform Defaults to FALSE.}

\item{recover_svd}{\code{Logical}. Recover singular values and eigenvectors of XY Defaults to FALSE.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}

\item{export_checkpoints_dir}{Automatically export generated models to this directory.}
}
\value{
an object of class \linkS4class{H2ODimReductionModel}.
}
\description{
Builds a generalized low rank decomposition of an H2O data frame
}
\examples{
\dontrun{
library(h2o)
h2o.init()
australia_path <- system.file("extdata", "australia.csv", package = "h2o")
australia <- h2o.uploadFile(path = australia_path)
h2o.glrm(training_frame = australia, k = 5, loss = "Quadratic", regularization_x = "L1",
         gamma_x = 0.5, gamma_y = 0, max_iterations = 1000)
}
}
\references{
M. Udell, C. Horn, R. Zadeh, S. Boyd (2014). {Generalized Low Rank Models}[http://arxiv.org/abs/1410.0342]. Unpublished manuscript, Stanford Electrical Engineering Department.
            N. Halko, P.G. Martinsson, J.A. Tropp. {Finding structure with randomness: Probabilistic algorithms for constructing approximate matrix decompositions}[http://arxiv.org/abs/0909.4061]. SIAM Rev., Survey and Review section, Vol. 53, num. 2, pp. 217-288, June 2011.
}
\seealso{
\code{\link{h2o.kmeans}, \link{h2o.svd}}, \code{\link{h2o.prcomp}}
}
