% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.round}
\alias{h2o.round}
\alias{round}
\title{Round doubles/floats to the given number of decimal places.}
\usage{
h2o.round(x, digits = 0)

round(x, digits = 0)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{digits}{Number of decimal places to round doubles/floats. Rounding to a negative number of decimal places is}
}
\description{
Round doubles/floats to the given number of decimal places.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "http://s3.amazonaws.com/h2o-public-test-data/smalldata/coxph_test/heart.csv"
heart <- h2o.importFile(f)

h2o.round(heart["age"], digits = 3)
}
}
\seealso{
\code{\link[base]{Round}} for the base R implementation, \code{round()}.
}
