% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.centersSTD}
\alias{h2o.centersSTD}
\title{Retrieve the Model Centers STD}
\usage{
h2o.centersSTD(object)
}
\arguments{
\item{object}{An \linkS4class{H2OClusteringModel} object.}
}
\description{
Retrieve the Model Centers STD
}
\examples{
\dontrun{
library(h2o)
h2o.init()
fr <- h2o.importFile("https://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv")
predictors <- c("sepal_len", "sepal_wid", "petal_len", "petal_wid")
km <- h2o.kmeans(x = predictors, training_frame = fr, k = 3, nfolds = 3)
h2o.centersSTD(km)
}
}
