% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.year}
\alias{h2o.year}
\alias{year}
\alias{year.H2OFrame}
\title{Convert Milliseconds to Years in H2O Datasets}
\usage{
h2o.year(x)

year(x)

\method{year}{H2OFrame}(x)
}
\arguments{
\item{x}{An H2OFrame object.}
}
\value{
An H2OFrame object containing the entries of \code{x} converted to years
}
\description{
Convert the entries of an H2OFrame object from milliseconds to years, indexed
starting from 1900.
}
\details{
This method calls the function of the MutableDateTime class in Java.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/jira/v-11-eurodate.csv"
hdf <- h2o.importFile(f)
h2o.year(hdf["ds9"])
}
}
\seealso{
\code{\link{h2o.month}}
}
