% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{h2o.varimp}
\alias{h2o.varimp}
\title{Retrieve the variable importance.}
\usage{
h2o.varimp(object, ...)
}
\arguments{
\item{object}{An H2O object.}

\item{...}{Additional arguments for specific use-cases.}
}
\description{
Retrieve the variable importance.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate_complete.csv.zip"
pros <- h2o.importFile(f)
response <- "GLEASON"
predictors <- c("ID", "AGE", "CAPSULE", "DCAPS", "PSA", "VOL", "DPROS")
aml <- h2o.automl(x = predictors, y = response, training_frame = pros, max_runtime_secs = 60)

h2o.varimp(aml, top_n = 20)  # get variable importance matrix for the top 20 models

h2o.varimp(aml@leader)  # get variable importance for the leader model
}
}
