% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.day}
\alias{h2o.day}
\alias{day}
\alias{day.H2OFrame}
\title{Convert Milliseconds to Day of Month in H2O Datasets}
\usage{
h2o.day(x)

day(x)

\method{day}{H2OFrame}(x)
}
\arguments{
\item{x}{An H2OFrame object.}
}
\value{
An H2OFrame object containing the entries of \code{x} converted to days of
        the month.
}
\description{
Converts the entries of an H2OFrame object from milliseconds to days of the month
(on a 1 to 31 scale).
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/jira/v-11-eurodate.csv"
hdf <- h2o.importFile(f)
h2o.day(hdf["ds9"])
}
}
\seealso{
\code{\link{h2o.month}}
}
