% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{h2o.model_correlation_heatmap}
\alias{h2o.model_correlation_heatmap}
\title{Model Prediction Correlation Heatmap}
\usage{
h2o.model_correlation_heatmap(
  object,
  newdata,
  top_n = 20,
  cluster_models = TRUE,
  triangular = TRUE
)
}
\arguments{
\item{object}{A list of H2O models, an H2O AutoML instance, or an H2OFrame with a 'model_id' column (e.g. H2OAutoML leaderboard).}

\item{newdata}{An H2O Frame.  Predictions from the models will be generated using this frame,
so this should be a holdout set.}

\item{top_n}{Integer specifying the number models shown in the heatmap (used only with an
AutoML object, and based on the leaderboard ranking.  Defaults to 20.}

\item{cluster_models}{Logical.  Order models based on their similarity.  Defaults to TRUE.}

\item{triangular}{Print just the lower triangular part of correlation matrix.  Defaults to TRUE.}
}
\value{
A ggplot2 object.
}
\description{
This plot shows the correlation between the predictions of the models.
For classification, frequency of identical predictions is used. By default, models
are ordered by their similarity (as computed by hierarchical clustering).
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the wine dataset into H2O:
f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/wine/winequality-redwhite-no-BOM.csv"
df <-  h2o.importFile(f)

# Set the response
response <- "quality"

# Split the dataset into a train and test set:
splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

# Build and train the model:
aml <- h2o.automl(y = response,
                  training_frame = train,
                  max_models = 10,
                  seed = 1)

# Create the model correlation heatmap
model_correlation_heatmap <- h2o.model_correlation_heatmap(aml, test)
print(model_correlation_heatmap)
}
}
