% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.negative_log_likelihood}
\alias{h2o.negative_log_likelihood}
\title{Extracts the final training negative log likelihood of a GLM model.}
\usage{
h2o.negative_log_likelihood(model)
}
\arguments{
\item{model}{an \linkS4class{H2OModel} object.}
}
\value{
The final training negative log likelihood of a GLM model.
}
\description{
Extracts the final training negative log likelihood of a GLM model.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement", "power", "weight", "acceleration", "year")
response <- "acceleration"
cars_model <- h2o.glm(y=response, 
                       x=predictors, 
                       training_frame = cars, 
                       family="gaussian",
                       generate_scoring_history=TRUE)
nllValue <- h2o.negative_log_likelihood(cars_model)
}
}
