% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.gains_lift_plot}
\alias{h2o.gains_lift_plot}
\title{Plot Gains/Lift curves}
\usage{
h2o.gains_lift_plot(object, type = c("both", "gains", "lift"), ...)
}
\arguments{
\item{object}{Either an H2OModel or H2OModelMetrics}

\item{type}{What curve to plot. One of "both", "gains", "lift".}

\item{...}{Optional arguments}
}
\description{
Plot Gains/Lift curves
}
\examples{
\dontrun{
library(h2o)
h2o.init()
data <- h2o.importFile(
path = "https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
model <- h2o.gbm(x = c("Origin", "Distance"), y = "IsDepDelayed", training_frame = data, ntrees = 1)
h2o.gains_lift_plot(model)
}
}
