% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automl.R
\name{h2o.get_leaderboard}
\alias{h2o.get_leaderboard}
\title{Retrieve the leaderboard from the AutoML instance.}
\usage{
h2o.get_leaderboard(object, extra_columns = NULL)
}
\arguments{
\item{object}{The object for which to return the leaderboard. Currently, only H2OAutoML instances are supported.}

\item{extra_columns}{A string or a list of string specifying which optional columns should be added to the leaderboard. Defaults to None.
Currently supported extensions are:
\itemize{
\item{'ALL': adds all columns below.}
\item{'training_time_ms': column providing the training time of each model in milliseconds (doesn't include the training of cross validation models).}
\item{'predict_time_per_row_ms': column providing the average prediction time by the model for a single row.}
\item{'algo': column providing the algorithm name for each model.}
}}
}
\value{
An H2OFrame representing the leaderboard.
}
\description{
Contrary to the default leaderboard attached to the automl instance, this one can return columns other than the metrics.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 30)
lb <- h2o.get_leaderboard(aml)
head(lb)
}
}
