% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.mae}
\alias{h2o.mae}
\title{Retrieve the Mean Absolute Error Value}
\usage{
h2o.mae(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{train}{Retrieve the training MAE}

\item{valid}{Retrieve the validation set MAE if a validation set was passed in during model build time.}

\item{xval}{Retrieve the cross-validation MAE}
}
\description{
Retrieves the mean absolute error (MAE) value from an H2O model.
If "train", "valid", and "xval" parameters are FALSE (default), then the training MAE value is returned. If more
than one parameter is set to TRUE, then a named vector of MAEs are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)

h <- h2o.init()
fr <- as.h2o(iris)

m <- h2o.deeplearning(x = 2:5, y = 1, training_frame = fr)

h2o.mae(m)
}
}
