% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{h2o.predict_json}
\alias{h2o.predict_json}
\title{H2O Prediction from R without having H2O running}
\usage{
h2o.predict_json(model, json, genmodelpath, labels, classpath, javaoptions)
}
\arguments{
\item{model}{String with file name of MOJO or POJO Jar}

\item{json}{JSON String with inputs to model}

\item{genmodelpath}{(Optional) path name to h2o-genmodel.jar, if not set defaults to same dir as MOJO}

\item{labels}{(Optional) if TRUE then show output labels in result}

\item{classpath}{(Optional) Extra items for the class path of where to look for Java classes, e.g., h2o-genmodel.jar}

\item{javaoptions}{(Optional) Java options string, default if "-Xmx4g"}
}
\value{
Returns an object with the prediction result
}
\description{
Provides the method h2o.predict with which you can predict a MOJO or POJO Jar model
from R.
}
\examples{
\dontrun{
library(h2o)
h2o.predict_json('~/GBM_model_python_1473313897851_6.zip', '{"C7":1}')
h2o.predict_json('~/GBM_model_python_1473313897851_6.zip', '{"C7":1}', c(".", "lib"))
}
}
