% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.week}
\alias{h2o.week}
\alias{week}
\alias{week.H2OFrame}
\title{Convert Milliseconds to Week of Week Year in H2O Datasets}
\usage{
h2o.week(x)

week(x)

\method{week}{H2OFrame}(x)
}
\arguments{
\item{x}{An H2OFrame object.}
}
\value{
An H2OFrame object containing the entries of \code{x} converted to weeks of
        the week year.
}
\description{
Converts the entries of an H2OFrame object from milliseconds to weeks of the week
year (starting from 1).
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/jira/v-11-eurodate.csv"
hdf <- h2o.importFile(f)
h2o.week(hdf["ds9"])
}
}
\seealso{
\code{\link{h2o.month}}
}
