% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.mean}
\alias{h2o.mean}
\alias{mean.H2OFrame}
\title{Mean of a column}
\usage{
h2o.mean(x, ..., na.rm = TRUE)

\method{mean}{H2OFrame}(x, ..., na.rm = TRUE)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{...}{Further arguments to be passed from or to other methods.}

\item{na.rm}{A logical value indicating whether \code{NA} or missing values should be stripped before the computation.}
}
\description{
Obtain the mean of a column of a parsed H2O data object.
}
\examples{
\donttest{
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
mean(prostate.hex$AGE)
}
}
\seealso{
\code{\link[base]{mean}} for the base R implementation.
}

