% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_utilities.R
\name{get_gcdist}
\alias{get_gcdist}
\title{Great circle distance}
\usage{
get_gcdist(pt1 = NULL, pt2 = NULL, units = c("m", "km"), simple = TRUE)
}
\arguments{
\item{pt1}{`sf` object with point geometry, `sfc_POINT` object, `sfg`
point, data frame or matrix.}

\item{pt2}{`sf` object with point geometry, `sfc_POINT` object, `sfg`
point, data frame or matrix.}

\item{units}{whether to return the great circle distance in meters or
kilometers.}

\item{simple}{whether to return a numeric vector of distances or a
`data.frame` containing start and end coordinates as well as distance.}
}
\value{
Numeric vector of point to point distances, or data frame of origin
  and destination coordinates accompanied by their distances.
}
\description{
Get the great circle distance between WGS84 lat/long points
}
\note{
This functionality also exists in R packages \code{sp},
\code{geosphere} and \code{fields}. H3's version appears to return slightly
shorter distances than most other implementations, but is included here
for completeness.
}
\examples{
# distance between Brisbane and Melbourne
bne <- c(153.028, -27.468)
mlb <- c(144.963, -37.814)
get_gcdist(bne, mlb, 'km')
}
