% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{get_disk}
\alias{get_disk}
\title{Get nearby H3 cell indices}
\usage{
get_disk(h3_address = NULL, ring_size = 1, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character cell index generated by H3.}

\item{ring_size}{Character; number of steps away from the central cell.
Defaults to 1.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a list of \code{length(h3_address)}. Each list element
  contains a character vector of H3 cells.
}
\description{
This function returns all the H3 cell indices within a specified number of
steps from the index supplied.
}
\note{
The number of cells returned for each input index conforms to the
  \href{https://en.wikipedia.org/wiki/Centered_hexagonal_number}{centered
  hexagonal number sequence}, so at \code{ring_size = 5}, 91 addresses are
  returned. The first address returned is the input address, the rest follow
  in a spiral anticlockwise order.
}
\examples{
# What are all the neighbours of this cell within two steps?
get_disk(h3_address = '86be8d12fffffff', ring_size = 2)
}
