% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HALSacc.R
\name{HALSacc}
\alias{HALSacc}
\title{Accelerated hierarchical alternating least squares NMF. For a reference to the method, see N. Gillis, 
Nonnegative matrix factorization: complexity, algorithms and applications 
[Section 4.2, Algo. 6], PhD thesis, Université catholique de Louvain, February 2011.}
\usage{
HALSacc(X, nmfMod, alpha = 1, maxiter = 1000, checkDivergence = FALSE)
}
\arguments{
\item{X}{Input data matrix, each column represents one data point 
and the rows correspond to the different features}

\item{nmfMod}{Valid NMF model, containing initialized factor matrices
(in accordance with the NMF package definition)}

\item{alpha}{Nonnegative parameter of the accelerated method}

\item{maxiter}{Maximum number of iterations}

\item{checkDivergence}{currently not in use, to be implemented}
}
\value{
Resulting NMF model (in accordance with the NMF package definition)
}
\description{
Accelerated hierarchical alternating least squares NMF. For a reference to the method, see N. Gillis, 
Nonnegative matrix factorization: complexity, algorithms and applications 
[Section 4.2, Algo. 6], PhD thesis, Université catholique de Louvain, February 2011.
}
\author{
nsauwen
}
