% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{wrapper - s and summary funs}
\alias{wrapper - s and summary funs}
\alias{max_}
\alias{sum_}
\alias{min_}
\alias{mean_}
\alias{median_}
\alias{sd_}
\alias{var_}
\alias{first_}
\alias{last_}
\title{Combine aggregate functions and s}
\usage{
sum_(..., ignore_na = TRUE)

mean_(..., ignore_na = TRUE)

max_(..., ignore_na = TRUE)

min_(..., ignore_na = TRUE)

median_(..., ignore_na = TRUE)

sd_(..., ignore_na = TRUE)

var_(..., ignore_na = TRUE)

first_(..., ignore_na = TRUE)

last_(..., ignore_na = TRUE)

min_(..., ignore_na = TRUE)

sum_(..., ignore_na = TRUE)

mean_(..., ignore_na = TRUE)

median_(..., ignore_na = TRUE)

sd_(..., ignore_na = TRUE)

var_(..., ignore_na = TRUE)

first_(..., ignore_na = TRUE)

last_(..., ignore_na = TRUE)
}
\arguments{
\item{...}{one or more vectors}

\item{ignore_na}{if false missing values are not omitted.}
}
\value{
a single aggregated value
}
\description{
\code{[summary function_*]} functions are simple wrappers of aggregate function
and the \code{s} function. \code{s} removes all non-values,
i.e. \code{NA,Inf,NaN}  from a vector.
However, if the length is 0 it returns NA. The result is then passed to the
corresponding aggregation function. For example,
\code{min_(x)} is identical to \code{min(s(x))}. Please read \code{vignette("s")} for more information.
}
\examples{
## sum_ on non-rational numeric vector
vector <- c(7, NaN, -Inf, 4)
sum_(vector)

## Min of vector with length 0
vector <- c()
# With a wrapped s
min_(vector)

## Max of vector with only NA
# With a wrapped s
max_(vector)

## Use of s when NA should not be removed
vector <- c(7, Inf, NA, 4)
# With a wrapped s
sum_(vector, ignore_na = FALSE)

}
\seealso{
\code{vignette("convert")}, \code{vignette("hablar")}
}
