% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hablar.R
\name{fun_by_row tidyverse_syntax for funs on rows}
\alias{fun_by_row tidyverse_syntax for funs on rows}
\alias{row_sum_}
\alias{row_sum}
\alias{row_mean_}
\alias{row_mean}
\title{row functions inside dplyr mutate}
\usage{
row_sum(..., ignore_na = FALSE, rationalize = FALSE)

row_sum_(..., ignore_na = TRUE, rationalize = TRUE)

row_mean(..., ignore_na = FALSE, rationalize = FALSE)

row_sum_(..., ignore_na = TRUE, rationalize = TRUE)

row_sum(..., ignore_na = FALSE, rationalize = FALSE)

row_mean_(..., ignore_na = TRUE, rationalize = TRUE)

row_mean(..., ignore_na = FALSE, rationalize = FALSE)
}
\arguments{
\item{...}{vars or tidyselect function}

\item{ignore_na}{a logical indicating whether missing values should be removed}

\item{rationalize}{a logical indicating whether irriational values (NaN, Inf) should be removed}
}
\value{
a single numeric vector of the same length as the data frame it
is applied to.
}
\description{
Simple and tidyversish syntac for sum and mean of a row, or select vars.
The suffix *_ version of the function removes irrational numbers and NA by default. 

Must be used inside the dplyr function \code{mutate} in order to work.
}
\examples{

\dontrun{
mtcars \%>\% 
  mutate(sum_of_row = row_sum_(cyl:wt))
  
mtcars \%>\% 
  mutate(mean_of_row = row_mean(disp, drat, gear))
} 

}
\seealso{
\code{vignette("s")}, \code{vignette("hablar")}
}
