% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdh.R
\name{rdh}
\alias{rdh}
\title{Calculate rugosity, fractal dimension, and height for a DEM}
\usage{
rdh(
  data,
  lvec,
  method_fd = "hvar",
  method_rg = "area",
  parallel = FALSE,
  ncores = (parallel::detectCores() - 1),
  ...
)
}
\arguments{
\item{data}{A dem of class RasterLayer.}

\item{lvec}{Scales to use for calculation.}

\item{method_fd}{method for the calculation of rugosity and fractal dimension.
Can be "hvar", "sd", "cubes", or "area". Defaults to "hvar".}

\item{method_rg}{Method to be used for the rugosity calculation. Defaults to "area".}

\item{parallel}{Logical. Use parallel processing? Defaults to FALSE.}

\item{ncores}{Number of cores to use if parallel = TRUE.}

\item{...}{Additional arguments see \code{\link[=fd]{fd()}}.}
}
\value{
A dataframe with the three complexity metrics.
}
\description{
Calculate rugosity, fractal dimension, and height for a DEM
}
\details{
Uses area method for rugosity and hvar method for fractal dimension calculations as default.
}
\examples{

dem <- dem_sample(horseshoe, L = 1)
rdh(dem, lvec = c(0.125, 0.25, 0.5, 1))
}
\seealso{
\code{\link[=fd]{fd()}}

\code{\link[=rg]{rg()}}

\code{\link[=hr]{hr()}}
}
