% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevp.R
\name{gevp2amplitude}
\alias{gevp2amplitude}
\title{Extracts physical amplitudes from a GEVP}
\usage{
gevp2amplitude(gevp, mass, id = 1, op.id = 1, type = "cosh", t1, t2,
  useCov = TRUE, fit = TRUE)
}
\arguments{
\item{gevp}{An object of class \code{gevp} as generated with a call to
\code{bootstrap.gevp}.}

\item{mass}{Optimally, this is an object either of class
\code{effectivemassfit} generated using \code{\link{fit.effectivemass}} or
of class \code{matrixfit} generated with \code{\link{matrixfit}} to the
principal correlator extracted using \code{\link{gevp2cf}} applied to
\code{gevp} using the same value of \code{id}.

It can also be given as a numerical vector with the bootstrap samples as
entries. The mean will then be computed as the bootstrap mean over this
vector. The number of samples must agree with the number of bootstrap
samples in \code{gevp}.}

\item{id}{The index of the principal correlator to extract, i.e. the
physical state to extract.}

\item{op.id}{The index of the operator for which to extract the amplitude.}

\item{type}{The symmetry of the pricipal correlator in time, can be either
"cosh" or "sinh".}

\item{t1, t2}{The time range in which to fit the amplitude starting with 0.
If not given it will be tried to infer these from the \code{mass} object.}

\item{useCov}{Use the covariance matrix for fitting the constant to the
amplitude data.}

\item{fit}{perform a fit to the data.}
}
\value{
Returns an object of S3 class \code{gevp.amplitude}, generated as a list with named
elements \code{amplitude} the numeric vector of amplitudes, \code{amplitude.tsboot}
the corresponding bootstrap samples, \code{damplitude} the estimates for the
standard errors, \code{fit} the object returned by the fit routine,
\code{meanAmplitude} and \code{meanAmplitude.tsboot} mean amplitude and its
bootstrap samples, \code{chisqr} the residual sum of squares, \code{dof} the numberi of
degrees of freedom, \code{t1} and \code{t2} the fit range, and then all the input
objects.
}
\description{
Given a GEVP generated with \code{bootstrap.gevp} and masses determined from
the principle correlator with given \code{id}, the physical amplitudes are
extracted and bootstraped. The man amplitude is determined from a constant
fit to the data in the specified time range.
}
\examples{

data(correlatormatrix)
## bootstrap the correlator matrix
correlatormatrix <- bootstrap.cf(correlatormatrix, boot.R=99, boot.l=1, seed=132435)
## solve the GEVP
t0 <- 4
correlatormatrix.gevp <- bootstrap.gevp(cf=correlatormatrix, t0=t0, element.order=c(1,2,3,4))
## extract the ground state and plot
pion.pc1 <- gevp2cf(gevp=correlatormatrix.gevp, id=1)
pion.pc1.effectivemass <- bootstrap.effectivemass(cf=pion.pc1, type="solve")
pion.pc1.effectivemass <- fit.effectivemass(pion.pc1.effectivemass, t1=8, t2=23,
                                            useCov=FALSE)
## now determine the amplitude
pion.pc1.amplitude <- gevp2amplitude(correlatormatrix.gevp, pion.pc1.effectivemass,
                                     useCov=FALSE, t1=8, t2=14)
plot(pion.pc1.amplitude)
summary(pion.pc1.amplitude)

}
\seealso{
\code{\link{matrixfit}}, \code{\link{fit.effectivemass}},
\code{\link{gevp}}, \code{\link{gevp2cf}}, \code{\link{computefps}}
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
\keyword{GEVP}
