% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_hal9001.R
\name{SL.hal9001}
\alias{SL.hal9001}
\title{Wrapper for Classic SuperLearner}
\usage{
SL.hal9001(
  Y,
  X,
  newX = NULL,
  family = stats::gaussian(),
  obsWeights = rep(1, length(Y)),
  id = NULL,
  max_degree = ifelse(ncol(X) >= 20, 2, 3),
  smoothness_orders = 1,
  num_knots = ifelse(smoothness_orders >= 1, 25, 50),
  reduce_basis = 1/sqrt(length(Y)),
  lambda = NULL,
  ...
)
}
\arguments{
\item{Y}{A \code{numeric} vector of observations of the outcome variable.}

\item{X}{An input \code{matrix} with dimensions number of observations -by-
number of covariates that will be used to derive the design matrix of basis
functions.}

\item{newX}{A matrix of new observations on which to obtain predictions. The
default of \code{NULL} computes predictions on training inputs \code{X}.}

\item{family}{A \code{\link[stats]{family}} object (one that is supported
by \code{\link[glmnet]{glmnet}}) specifying the error/link family for a
generalized linear model.}

\item{obsWeights}{A \code{numeric} vector of observational-level weights.}

\item{id}{A \code{numeric} vector of IDs.}

\item{max_degree}{The highest order of interaction terms for which basis
functions ought to be generated.}

\item{smoothness_orders}{An \code{integer} vector of length 1 or greater,
specifying the smoothness of the basis functions. See the argument
\code{smoothness_orders} of \code{\link{fit_hal}} for more information.}

\item{num_knots}{An \code{integer} vector of length 1 or \code{max_degree},
specifying the maximum number of knot points (i.e., bins) for each
covariate for generating basis functions. See \code{num_knots} argument in
\code{\link{fit_hal}} for more information.}

\item{reduce_basis}{A \code{numeric} value bounded in the open unit interval
indicating the minimum proportion of 1's in a basis function column needed
for the basis function to be included in the procedure to fit the lasso.
Any basis functions with a lower proportion of 1's than the cutoff will be
removed.}

\item{lambda}{A user-specified sequence of values of the regularization
parameter for the lasso L1 regression. If \code{NULL}, the default sequence
in \code{\link[glmnet]{cv.glmnet}} will be used. The cross-validated
optimal value of this regularization parameter will be selected with
\code{\link[glmnet]{cv.glmnet}}.}

\item{...}{Not used.}
}
\value{
An object of class \code{SL.hal9001} with a fitted \code{hal9001}
object and corresponding predictions based on the input data.
}
\description{
Wrapper for \pkg{SuperLearner} for objects of class \code{hal9001}
}
