% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_lasso.R
\name{lassi_origami}
\alias{lassi_origami}
\title{Single Lasso estimation for cross-validation with Origami}
\usage{
lassi_origami(fold, data, lambdas, center = FALSE)
}
\arguments{
\item{fold}{A \code{fold} object produced by a call to \code{make_folds}
from the \pkg{origami}.}

\item{data}{A \code{dgCMatrix} object containing the outcome values (Y) in
its first column and vectors corresponding to the basis functions of HAL in
all other columns. Consult the description of HAL regression for details.}

\item{lambdas}{A \code{numeric} vector corresponding to a sequence of lambda
values obtained by fitting the Lasso on the full data.}

\item{center}{binary. If \code{TRUE}, covariates are centered. This is much
slower, but matches the \code{glmnet} implementation. Default \code{FALSE}.}
}
\description{
Fits Lasso regression over a single fold of a cross-validated data set. This
is meant to be called using \code{\link[origami]{cross_validate}}, which is
done through \code{\link{cv_lasso}}. Note that this procedure is NOT meant
to be invoked by itself. INTERNAL USE ONLY.
}
