% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cfc}
\alias{cfc}
\title{A Dataframe of Cluster Fill Counts}
\format{
A dataframe with 2 rows and 15 variables:
\describe{
\item{docname}{The file name of the handwriting sample.}
\item{writer}{Writer ID.}
\item{doc}{The name of the handwriting prompt.}
\item{3}{The number of graphs in cluster 3.}
\item{10}{The number of graphs in cluster 10.}
\item{12}{The number of graphs in cluster 12.}
\item{15}{The number of graphs in cluster 15.}
\item{16}{The number of graphs in cluster 16.}
\item{17}{The number of graphs in cluster 17.}
\item{19}{The number of graphs in cluster 19.}
\item{20}{The number of graphs in cluster 20.}
\item{23}{The number of graphs in cluster 23.}
\item{25}{The number of graphs in cluster 25.}
\item{27}{The number of graphs in cluster 27.}
\item{29}{The number of graphs in cluster 29.}
}
}
\source{
\url{https://forensicstats.org/handwritingdatabase/}
}
\usage{
cfc
}
\description{
The cfc dataframe contains cluster fill counts for two documents from the
CSAFE Handwriting Database: w0238_s01_pWOZ_r02.rds and
w0238_s01_pWOZ_r03.rds.
}
\details{
The documents were split into graphs with
\code{\link[handwriter]{process_batch_dir}}. The graphs were grouped into
clusters with \code{\link[handwriter]{get_clusters_batch}} and the cluster
template \code{\link[handwriter]{templateK40}}. The number of graphs in each
cluster, the cluster fill counts, were counted with
\code{\link[handwriter]{get_cluster_fill_counts}}. The dataframe cfc has a
column for each cluster in \code{\link[handwriter]{templateK40}} that has at
least one graph from w0238_s01_pWOZ_r02.rds or w0238_s01_pWOZ_r03.rds
assigned to it. Empty clusters do not have columns in cfc, so cfc only has 12
cluster columns instead of 40.
}
\keyword{datasets}
