% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{inspect_window_avLink,hbr-method}
\alias{inspect_window_avLink}
\alias{inspect_window_avLink,hbr-method}
\alias{inspect_window_avLink.hbr}
\title{Hierachical clustering of haplotype-block marker for a window}
\usage{
\S4method{inspect_window_avLink}{hbr}(object, window, min.cl.cor = 0,
  plotDendro = T, plotCluster = T)
}
\arguments{
\item{object}{object of class \code{\link{hbr}} containing the results of 
reconstructed haplotype-blocks}

\item{window}{number of the window, which should be inspected}

\item{min.cl.cor}{minimum cluster correlation, if none is provided, the min.cl.cor
of the provided \code{\link{hbr}} object is taken.}

\item{plotDendro}{Boolean indicating if dendrogram using average
linkage clustering should be plotted.}

\item{plotCluster}{Boolean indicating if clusters identified with average
linkage clustering should be visualized in PCs.}
}
\description{
Performs average linkage clustering for all SNPs in a window 
after filtering (i.e. \code{\link{initialize_SNP_time_series}}).
}
\details{
Performs average linkage clustering on the time series data 
of the filtered SNPs and the selected time points (filtered and selected 
through \code{use.libs} in \code{\link{initialize_SNP_time_series}})
in a given window. The horizontal red line indicates the correlation
(1-correlation) threshold on which clusters were originally identified. 
Note: Clusters with less than \code{min.cl.cor} markers are discarded.
If no horizontal line is shown this indicates that all SNPs were assigned
to the same cluster.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

