% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{summary,hbr-method}
\alias{summary,hbr-method}
\alias{summary.hbr}
\title{Method to summarize information of reconstructed haplotype-blocks}
\usage{
\S4method{summary}{hbr}(object, min.marker = 1)
}
\arguments{
\item{object}{object of class \code{\link{hbr}} containing the results of reconstructed haplotype
blocks to be summarized.}

\item{min.marker}{numeric specifying the minimum number of markers a haplotype-block to be 
reported. NOTE: IDs of haplotype-blocks in the provided summary are identical to the 
IDs of the previously identified blocks.}
}
\value{
data.table with row entries for each reconstructed haplotype-block and columns for:
chr (chromosome), id (numbering of selected blocks), n.marker (number of markers in the 
reconstructed block), spos, epos (starting and end position of the block), len.pos (length
of the block in bp), MperMb (number of markers per Mb), swin, ewin (starting and end window of the block)
}
\description{
The method summarizes information of the reconstructed haplotype-blocks for a chromosome.
}
\details{
The method operates on \code{\link{hbr}} objects and summarizes information of 
reconstructed haplotype-blocks
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

